(* ::Package:: *)

(* ::Title:: *)
(*Martin Welz - posts on Sci.Math.Symbolic*)


(* ::Section::Closed:: *)
(*4 June 2010*)


(* {x*(x^2 + 3)/(2*a^2 + b^2*(x^2 + 1))^(5/2)*Log[(Sqrt[2]*x*Sqrt[2*a^2 + b^2*(x^2 + 1)] - 2*x*a + b*(x^2 + 1))/x], x, 0, Sqrt[2]*(43*a^6 + 63*b^2*a^4 + 33*b^4*a^2 + 5*b^6)*(ArcTan[b*(x/Sqrt[2*a^2 + b^2])]/(6*b^4*Sqrt[2*a^2 + b^2]*(3*a^2 + b^2)^3)) + Sqrt[2]*(Sqrt[4*a^2 + b^2] + a)^3*(3*a*Sqrt[4*a^2 + b^2] - 7*a^2 - 2*b^2)*(Log[Sqrt[2]*(Sqrt[4*a^2 + b^2] - a)*Sqrt[2*a^2 + b^2*(x^2 + 1)] + b*x*Sqrt[4*a^2 + b^2] + 2*a^2 - 2*b*x*a + b^2]/(6*b^4*(3*a^2 + b^2)^3)) + Sqrt[2]*(Sqrt[4*a^2 + b^2] - a)^3*(3*a*Sqrt[4*a^2 + b^2] + 7*a^2 + 2*b^2)*(Log[Sqrt[2]*(Sqrt[4*a^2 + b^2] + a)*Sqrt[2*a^2 + b^2*(x^2 + 1)] + b*x*Sqrt[4*a^2 + b^2] - 2*a^2 + 2*b*x*a - b^2]/(6*b^4*(3*a^2 + b^2)^3)) - (4*a^2 + b^2*(3*x^2 + 5))*(Log[(Sqrt[2]*x*Sqrt[2*a^2 + b^2*(x^2 + 1)] - 2*x*a + b*(x^2 + 1))/x]/(3*b^4*(2*a^2 + b^2*(x^2 + 1))^(3/2))) - (4*a^2 + 5*b^2)*(Log[(Sqrt[2*a^2 + b^2*(x^2 + 1)] - Sqrt[2*a^2 + b^2])/x]/(3*b^4*(2*a^2 + b^2)^(3/2))) + Sqrt[2]*(2*a^2 + b^2)*(Log[Sqrt[2*a^2 + b^2*(x^2 + 1)] - Sqrt[2]*a]/(6*b^4*a^3)) - Sqrt[2]*(5*a^2 + b^2)*(8*a^6 + 9*b^2*a^4 + 6*b^4*a^2 + b^6)*(Log[2*a^2 + b^2*(x^2 + 1)]/(12*b^4*a^3*(3*a^2 + b^2)^3)) + Sqrt[2]*(b^2 - a^2)*((Sqrt[2]*Sqrt[2*a^2 + b^2*(x^2 + 1)]*(10*a^6 + 2*b*x*a^5 + 16*b^2*a^4 + 7*b^4*a^2 + b^6) + 12*a^7 + 6*b*x*a^6 + 16*b^2*a^5 + 5*b^3*x*a^4 + 7*b^4*a^3 + b^5*x*a^2 + b^6*a)/(6*b^4*a^2*(2*a^2 + b^2)*(2*a^2 + b^2*(x^2 + 1))*(3*a^2 + b^2)^2))} *)

(* The following two integrands are equivalent! *)
{1/Sqrt[1 - a*x], x, 1, -((2*Sqrt[1 - a*x])/a)}
{(Log[a*x - 1] - 2*Log[-Sqrt[a*x - 1]])/(2*Pi*Sqrt[a*x - 1]), x, 5, -((2*Sqrt[1 - a*x])/a), -((2*Sqrt[-1 + a*x]*Log[-Sqrt[-1 + a*x]])/(a*Pi)) + (Sqrt[-1 + a*x]*Log[-1 + a*x])/(a*Pi)}


(* ::Section::Closed:: *)
(*6 June 2010*)


(* {Sqrt[b^2*x^2 + 2*a^2 + b^2]/(b^3*x^4 + 4*a*b^2*x^3 + 2*a^2*b*x^2 + 4*a*x*(2*a^2 + b^2) - b*(2*a^2 + b^2)), x, 0, 0}
{Sqrt[b^2*x^2 + 2*a^2 + b^2]/(b^3*x^6 + 4*a*b^2*x^5 + b*x^4*(2*a^2 + b^2) + 8*a*x^3*(a^2 + b^2) - b^3*x^2 + 4*a*x*(2*a^2 + b^2) - b*(2*a^2 + b^2)), x, 0, 0}
{x/((b^2*x^2 + 2*a^2 + b^2)*((b*x^2 - 2*a*x + b)*Sqrt[b^2*x^2 + 2*a^2 + b^2] + Sqrt[2]*b^2*x^3 + Sqrt[2]*x*(2*a^2 + b^2))), x, 0, 0} *)


(* ::Section::Closed:: *)
(*20 June 2010*)


(* ::Subsubsection::Closed:: *)
(*Problem #1*)


{1/(Sqrt[x^2 + 1] + 2*x)^2, x, 9, (4*x)/(3*(1 - 3*x^2)) - (2*Sqrt[1 + x^2])/(3*(1 - 3*x^2)) - ArcTanh[Sqrt[3]*x]/(3*Sqrt[3]) + ArcTanh[(1/2)*Sqrt[3]*Sqrt[1 + x^2]]/(3*Sqrt[3])}


(* ::Subsubsection::Closed:: *)
(*Problem #2*)


{1/(Sqrt[x^2 - 1]*(3*x^2 - 4)^2), x, 3, (3*x*Sqrt[-1 + x^2])/(8*(4 - 3*x^2)) + (5/16)*ArcTanh[x/(2*Sqrt[-1 + x^2])]}


(* ::Subsubsection::Closed:: *)
(*Problem #3*)


{1/(2*Sqrt[x] + Sqrt[x + 1])^2, x, 8, 8/(9*(1 - 3*x)) - (4*Sqrt[x]*Sqrt[1 + x])/(3*(1 - 3*x)) - (8*ArcSinh[Sqrt[x]])/9 + (10/9)*ArcTanh[(2*Sqrt[x])/Sqrt[1 + x]] + (5/9)*Log[1 - 3*x]}


(* ::Subsubsection::Closed:: *)
(*Problem #4*)


{Sqrt[x^2 - 1]/(x - I)^2, x, 6, Sqrt[-1 + x^2]/(I - x) - (I*ArcTan[(1 - I*x)/(Sqrt[2]*Sqrt[-1 + x^2])])/Sqrt[2] + ArcTanh[x/Sqrt[-1 + x^2]]}


(* ::Subsubsection::Closed:: *)
(*Problem #5*)


{1/(Sqrt[x^2 - 1]*(x^2 + 1)^2), x, 3, -((x*Sqrt[-1 + x^2])/(4*(1 + x^2))) + (3*ArcTanh[(Sqrt[2]*x)/Sqrt[-1 + x^2]])/(4*Sqrt[2])}


(* ::Subsubsection::Closed:: *)
(*Problem #6*)


{1/(Sqrt[x - 1]*(Sqrt[x - 1] + Sqrt[x])^2), x, 4, 2*Sqrt[-1 + x] + (4/3)*(-1 + x)^(3/2) - (4*x^(3/2))/3}


(* ::Subsubsection::Closed:: *)
(*Problem #7*)


{1/(Sqrt[x^2 - 1]*(Sqrt[x^2 - 1] + Sqrt[x])^2), x, -18, (2 - 4*x)/(5*(Sqrt[x] + Sqrt[-1 + x^2])) + (1/25)*Sqrt[-110 + 50*Sqrt[5]]*ArcTan[(1/2)*Sqrt[2 + 2*Sqrt[5]]*Sqrt[x]] - (1/50)*Sqrt[-110 + 50*Sqrt[5]]*ArcTan[(Sqrt[-2 + 2*Sqrt[5]]*Sqrt[-1 + x^2])/(2 - (1 - Sqrt[5])*x)] - (1/25)*Sqrt[110 + 50*Sqrt[5]]*ArcTanh[(1/2)*Sqrt[-2 + 2*Sqrt[5]]*Sqrt[x]] - (1/50)*Sqrt[110 + 50*Sqrt[5]]*ArcTanh[(Sqrt[2 + 2*Sqrt[5]]*Sqrt[-1 + x^2])/(2 - x - Sqrt[5]*x)]}


{(Sqrt[x] - Sqrt[-1 + x^2])^2/((1 + x - x^2)^2*Sqrt[-1 + x^2]), x, -25, (2 - 4*x)/(5*(Sqrt[x] + Sqrt[-1 + x^2])) + (1/25)*Sqrt[-110 + 50*Sqrt[5]]*ArcTan[(1/2)*Sqrt[2 + 2*Sqrt[5]]*Sqrt[x]] - (1/50)*Sqrt[-110 + 50*Sqrt[5]]*ArcTan[(Sqrt[-2 + 2*Sqrt[5]]*Sqrt[-1 + x^2])/(2 - (1 - Sqrt[5])*x)] - (1/25)*Sqrt[110 + 50*Sqrt[5]]*ArcTanh[(1/2)*Sqrt[-2 + 2*Sqrt[5]]*Sqrt[x]] - (1/50)*Sqrt[110 + 50*Sqrt[5]]*ArcTanh[(Sqrt[2 + 2*Sqrt[5]]*Sqrt[-1 + x^2])/(2 - x - Sqrt[5]*x)]}


{1/(Sqrt[2]*(1 + x)^2*Sqrt[-I + x^2]) + 1/(Sqrt[2]*(1 + x)^2*Sqrt[I + x^2]), x, 7, -(((1/2 + I/2)*Sqrt[-I + x^2])/(Sqrt[2]*(1 + x))) - ((1/2 - I/2)*Sqrt[I + x^2])/(Sqrt[2]*(1 + x)) + ArcTanh[(I + x)/(Sqrt[1 - I]*Sqrt[-I + x^2])]/((1 - I)^(3/2)*Sqrt[2]) - ArcTanh[(I - x)/(Sqrt[1 + I]*Sqrt[I + x^2])]/((1 + I)^(3/2)*Sqrt[2])}


(* ::Subsubsection::Closed:: *)
(*Problem #8*)


{Sqrt[Sqrt[x^4 + 1] + x^2]/((x + 1)^2*Sqrt[x^4 + 1]), x, 7, -(Sqrt[1 - I*x^2]/(2*(1 + x))) - Sqrt[1 + I*x^2]/(2*(1 + x)) - (1/4)*(1 - I)^(3/2)*ArcTanh[(1 + I*x)/(Sqrt[1 - I]*Sqrt[1 - I*x^2])] - (1/4)*(1 + I)^(3/2)*ArcTanh[(1 - I*x)/(Sqrt[1 + I]*Sqrt[1 + I*x^2])]}
{Sqrt[Sqrt[x^4 + 1] + x^2]/((x + 1)*Sqrt[x^4 + 1]), x, 5, (-(1/2))*Sqrt[1 - I]*ArcTanh[(1 + I*x)/(Sqrt[1 - I]*Sqrt[1 - I*x^2])] - (1/2)*Sqrt[1 + I]*ArcTanh[(1 - I*x)/(Sqrt[1 + I]*Sqrt[1 + I*x^2])]}
{Sqrt[Sqrt[x^4 + 1] + x^2]/Sqrt[x^4 + 1], x, 2, ArcTanh[(Sqrt[2]*x)/Sqrt[x^2 + Sqrt[1 + x^4]]]/Sqrt[2]}
{Sqrt[Sqrt[x^4 + 1] - x^2]/Sqrt[x^4 + 1], x, 2, ArcTan[(Sqrt[2]*x)/Sqrt[-x^2 + Sqrt[1 + x^4]]]/Sqrt[2]}


(* ::Subsubsection::Closed:: *)
(*Problem #9*)


{((x - 1)^(3/2) + (x + 1)^(3/2))/((x + 1)^(3/2)*(x - 1)^(3/2)), x, 2, -(2/Sqrt[-1 + x]) - 2/Sqrt[1 + x]}


(* ::Section::Closed:: *)
(*15 August 2010*)


{(x + Sqrt[x^2 + a])^b, x, 3, -((a*(x + Sqrt[a + x^2])^(-1 + b))/(2*(1 - b))) + (x + Sqrt[a + x^2])^(1 + b)/(2*(1 + b))}
{(x - Sqrt[x^2 + a])^b, x, 3, -((a*(x - Sqrt[a + x^2])^(-1 + b))/(2*(1 - b))) + (x - Sqrt[a + x^2])^(1 + b)/(2*(1 + b))}
{(x + Sqrt[x^2 + a])^b/Sqrt[x^2 + a], x, 2, (x + Sqrt[a + x^2])^b/b}
{(x - Sqrt[x^2 + a])^b/Sqrt[x^2 + a], x, 2, -((x - Sqrt[a + x^2])^b/b)}


{1/(a + b*E^(p*x))^2, x, 3, 1/(a*(a + b*E^(p*x))*p) + x/a^2 - Log[a + b*E^(p*x)]/(a^2*p)}
{1/(a*E^(p*x) + b*E^(-p*x))^2, x, 2, -(1/(2*a*(b + a*E^(2*p*x))*p))}
{x/(a*E^(p*x) + b*E^(-p*x))^2, x, 6, x/(2*a*b*p) - x/(2*a*(b + a*E^(2*p*x))*p) - Log[b + a*E^(2*p*x)]/(4*a*b*p^2)}


(* ::Section::Closed:: *)
(*2 September 2012*)


(* ::Item:: *)
(*Example from Welz's paper "Two-term Recurrence Formulae for Indefinite Algebraic Integrals" available at https://arxiv.org/abs/1209.3758v2*)


{(1 - x + 3*x^2)/((1 + x + x^2)^2*Sqrt[1 - x + x^2]), x, 6, ((1 + x)*Sqrt[1 - x + x^2])/(1 + x + x^2) + Sqrt[2]*ArcTan[(Sqrt[2]*(1 + x))/Sqrt[1 - x + x^2]] - ArcTanh[(Sqrt[2/3]*(1 - x))/Sqrt[1 - x + x^2]]/Sqrt[6]}


(* ::Section::Closed:: *)
(*21 January 2013*)


(* From James Davenport's algint package documentation for Reduce *)
{Sqrt[x + Sqrt[a^2 + x^2]]/Sqrt[a^2 + x^2], x, 2, 2*Sqrt[x + Sqrt[a^2 + x^2]]}
{Sqrt[b*x + Sqrt[a + b^2*x^2]]/Sqrt[a + b^2*x^2], x, 2, (2*Sqrt[b*x + Sqrt[a + b^2*x^2]])/b}


{1/(x*Sqrt[a^2 + x^2]*Sqrt[x + Sqrt[a^2 + x^2]]), x, 5, -((2*ArcTan[Sqrt[x + Sqrt[a^2 + x^2]]/Sqrt[a]])/a^(3/2)) - (2*ArcTanh[Sqrt[x + Sqrt[a^2 + x^2]]/Sqrt[a]])/a^(3/2)}
{Sqrt[Sqrt[a^2 + x^2] + x]/x, x, 6, 2*Sqrt[x + Sqrt[a^2 + x^2]] - 2*Sqrt[a]*ArcTan[Sqrt[x + Sqrt[a^2 + x^2]]/Sqrt[a]] - 2*Sqrt[a]*ArcTanh[Sqrt[x + Sqrt[a^2 + x^2]]/Sqrt[a]]}


(* ::Section::Closed:: *)
(*17 September 2014*)


{x^3*Log[2 + x]^3*Log[3 + x], x, If[$VersionNumber<10, 104, 105], -((282521*x)/1152) + (17857*x^2)/2304 - (763*x^3)/3456 + (3*x^4)/256 + (13/8)*(2 + x)^2 - (71/216)*(2 + x)^3 + (3/256)*(2 + x)^4 + (2069/144)*Log[2 + x] - (187/64)*x^2*Log[2 + x] + (83/288)*x^3*Log[2 + x] - (3/128)*x^4*Log[2 + x] + (6733/32)*(2 + x)*Log[2 + x] - (377/32)*(2 + x)^2*Log[2 + x] + (71/72)*(2 + x)^3*Log[2 + x] - (3/64)*(2 + x)^4*Log[2 + x] - (43/12)*Log[2 + x]^2 - (17/48)*x^3*Log[2 + x]^2 + (3/64)*x^4*Log[2 + x]^2 - (1251/16)*(2 + x)*Log[2 + x]^2 + (273/32)*(2 + x)^2*Log[2 + x]^2 - (3/4)*(2 + x)^3*Log[2 + x]^2 + (3/64)*(2 + x)^4*Log[2 + x]^2 + (65/4)*(2 + x)*Log[2 + x]^3 - (33/8)*(2 + x)^2*Log[2 + x]^3 + (3/4)*(2 + x)^3*Log[2 + x]^3 - (1/16)*(2 + x)^4*Log[2 + x]^3 + (150875*Log[3 + x])/1152 + 30*x*Log[3 + x] - (9/2)*x^2*Log[3 + x] + (4/9)*(2 + x)^3*Log[3 + x] - (3/128)*(2 + x)^4*Log[3 + x] - (5609/96)*Log[2 + x]*Log[3 + x] - 48*(2 + x)*Log[2 + x]*Log[3 + x] + 9*(2 + x)^2*Log[2 + x]*Log[3 + x] - (4/3)*(2 + x)^3*Log[2 + x]*Log[3 + x] + (3/32)*(2 + x)^4*Log[2 + x]*Log[3 + x] + (563/16)*Log[2 + x]^2*Log[3 + x] + 24*(2 + x)*Log[2 + x]^2*Log[3 + x] - 9*(2 + x)^2*Log[2 + x]^2*Log[3 + x] + 2*(2 + x)^3*Log[2 + x]^2*Log[3 + x] - (3/16)*(2 + x)^4*Log[2 + x]^2*Log[3 + x] - (65/4)*Log[2 + x]^3*Log[3 + x] - 8*(2 + x)*Log[2 + x]^3*Log[3 + x] + 6*(2 + x)^2*Log[2 + x]^3*Log[3 + x] - 2*(2 + x)^3*Log[2 + x]^3*Log[3 + x] + (1/4)*(2 + x)^4*Log[2 + x]^3*Log[3 + x] - (5609/96)*PolyLog[2, -2 - x] + (563/8)*Log[2 + x]*PolyLog[2, -2 - x] - (195/4)*Log[2 + x]^2*PolyLog[2, -2 - x] - (563/8)*PolyLog[3, -2 - x] + (195/2)*Log[2 + x]*PolyLog[3, -2 - x] - (195/2)*PolyLog[4, -2 - x]}


(* ::Section::Closed:: *)
(* 12 January 2016*)


{(Sqrt[x^2 + b] + x)^a/Sqrt[x^2 + b], x, 2, (x + Sqrt[b + x^2])^a/a}


{(Sqrt[x^2 + b] + x)^a, x, 3, -((b*(x + Sqrt[b + x^2])^(-1 + a))/(2*(1 - a))) + (x + Sqrt[b + x^2])^(1 + a)/(2*(1 + a))}


{(x^(3*a) + x^(2*a) + x^a)*(2*x^(2*a) + 3*x^a + 6)^(1/a), x, 2, (x^(1 + a)*(6 + 3*x^a + 2*x^(2*a))^(1 + 1/a))/(6*(1 + a))}


{1/(x*(1 - x^2)^(1/3)), x, 5, (1/2)*Sqrt[3]*ArcTan[(1 + 2*(1 - x^2)^(1/3))/Sqrt[3]] - Log[x]/2 + (3/4)*Log[1 - (1 - x^2)^(1/3)]}


{1/(x*(1 - x^2)^(2/3)), x, 5, (-(1/2))*Sqrt[3]*ArcTan[(1 + 2*(1 - x^2)^(1/3))/Sqrt[3]] - Log[x]/2 + (3/4)*Log[1 - (1 - x^2)^(1/3)]}


{1/(1 - x^3)^(1/3), x, 7, -(ArcTan[(1 - (2*x)/(1 - x^3)^(1/3))/Sqrt[3]]/Sqrt[3]) - (1/6)*Log[1 + x^2/(1 - x^3)^(2/3) - x/(1 - x^3)^(1/3)] + (1/3)*Log[1 + x/(1 - x^3)^(1/3)]}


{1/(x*(1 - x^3)^(1/3)), x, 5, ArcTan[(1 + 2*(1 - x^3)^(1/3))/Sqrt[3]]/Sqrt[3] - Log[x]/2 + (1/2)*Log[1 - (1 - x^3)^(1/3)]}


{1/((1 + x)*(1 - x^3)^(1/3)), x, -1, -((Sqrt[3]*ArcTan[(2*(1 - x) + 2^(2/3)*(1 - x^3)^(1/3))/(2^(2/3)*Sqrt[3]*(1 - x^3)^(1/3))])/(2*2^(1/3))) - Log[1 - x]/(4*2^(1/3)) - Log[1 + x]/(2*2^(1/3)) + (3*Log[-1 + x + 2^(2/3)*(1 - x^3)^(1/3)])/(4*2^(1/3))}


{x/((1 + x)*(1 - x^3)^(1/3)), x, -9, ArcTan[(2*x - (1 - x^3)^(1/3))/(Sqrt[3]*(1 - x^3)^(1/3))]/Sqrt[3] + (Sqrt[3]*ArcTan[(2*(1 - x) + 2^(2/3)*(1 - x^3)^(1/3))/(2^(2/3)*Sqrt[3]*(1 - x^3)^(1/3))])/(2*2^(1/3)) + Log[1 - x]/(4*2^(1/3)) + Log[1 + x]/(2*2^(1/3)) + (1/2)*Log[x + (1 - x^3)^(1/3)] - (3*Log[-1 + x + 2^(2/3)*(1 - x^3)^(1/3)])/(4*2^(1/3))}


{1/(x*(x^2 - 3*x + 2)^(1/3)), x, -2, -((Sqrt[3]*ArcTan[1/Sqrt[3] + (2^(1/3)*(2 - x))/(Sqrt[3]*(2 - 3*x + x^2)^(1/3))])/(2*2^(1/3))) - Log[2 - x]/(4*2^(1/3)) - Log[x]/(2*2^(1/3)) + (3*Log[2 - x - 2^(2/3)*(2 - 3*x + x^2)^(1/3)])/(4*2^(1/3))}


{1/(x^3 - 3*x^2 + 7*x - 5)^(1/3), x, -11, (1/2)*Sqrt[3]*ArcTan[1/Sqrt[3] + (2*(-1 + x))/(Sqrt[3]*(-5 + 7*x - 3*x^2 + x^3)^(1/3))] + (1/4)*Log[1 - x] - (3/4)*Log[1 - x + (-5 + 7*x - 3*x^2 + x^3)^(1/3)]}


{1/(x*(x^2 - q))^(1/3), x, -11, (1/2)*Sqrt[3]*ArcTan[1/Sqrt[3] + (2*x)/(Sqrt[3]*(x*(-q + x^2))^(1/3))] + Log[x]/4 - (3/4)*Log[-x + (x*(-q + x^2))^(1/3)]}


{1/((x - 1)*(x^2 - 2*x + q))^(1/3), x, -12, (1/2)*Sqrt[3]*ArcTan[1/Sqrt[3] + (2*(-1 + x))/(Sqrt[3]*((-1 + x)*(q - 2*x + x^2))^(1/3))] + (1/4)*Log[1 - x] - (3/4)*Log[1 - x + ((-1 + x)*(q - 2*x + x^2))^(1/3)]}


{1/(x*((x - 1)*(x^2 - 2*q*x + q))^(1/3)), x, -2, (Sqrt[3]*ArcTan[1/Sqrt[3] + (2*q^(1/3)*(-1 + x))/(Sqrt[3]*((-1 + x)*(q - 2*q*x + x^2))^(1/3))])/(2*q^(1/3)) + Log[1 - x]/(4*q^(1/3)) + Log[x]/(2*q^(1/3)) - (3*Log[(-q^(1/3))*(-1 + x) + ((-1 + x)*(q - 2*q*x + x^2))^(1/3)])/(4*q^(1/3))}


{(2 - (k + 1)*x)/((1 - (k + 1)*x)*(x*(1 - x)*(1 - k*x))^(1/3)), x, -6, (Sqrt[3]*ArcTan[(1 + (2*k^(1/3)*x)/((1 - x)*x*(1 - k*x))^(1/3))/Sqrt[3]])/k^(1/3) + Log[x]/(2*k^(1/3)) + Log[1 - (1 + k)*x]/(2*k^(1/3)) - (3*Log[(-k^(1/3))*x + ((1 - x)*x*(1 - k*x))^(1/3)])/(2*k^(1/3))}


{(1 - k*x)/((1 + (k - 2)*x)*(x*(1 - x)*(1 - k*x))^(2/3)), x, -1, -((Sqrt[3]*ArcTan[(1 + (2^(1/3)*(1 - k*x))/((1 - k)^(1/3)*((1 - x)*x*(1 - k*x))^(1/3)))/Sqrt[3]])/(2^(2/3)*(1 - k)^(1/3))) + Log[1 - (2 - k)*x]/(2^(2/3)*(1 - k)^(1/3)) + Log[1 - k*x]/(2*2^(2/3)*(1 - k)^(1/3)) - (3*Log[-1 + k*x + 2^(2/3)*(1 - k)^(1/3)*((1 - x)*x*(1 - k*x))^(1/3)])/(2*2^(2/3)*(1 - k)^(1/3))}


{(a + b*x + c*x^2)/((1 - x + x^2)*(1 - x^3)^(1/3)), x, -11, (-(1/6))*c*(2*Sqrt[3]*ArcTan[(1 - (2*x)/(1 - x^3)^(1/3))/Sqrt[3]] + Log[1 + x^2/(1 - x^3)^(2/3) - x/(1 - x^3)^(1/3)] - 2*Log[1 + x/(1 - x^3)^(1/3)]) + ((a - b - 2*c)*(-2*Sqrt[3]*ArcTan[(1 + 2^(2/3)*(1 - x^3)^(1/3))/Sqrt[3]] - 3*Log[2^(1/3) - (1 - x^3)^(1/3)]))/(12*2^(1/3)) + ((a + b)*(2*Sqrt[3]*ArcTan[(1 + (2*2^(1/3)*(-1 + x))/(1 - x^3)^(1/3))/Sqrt[3]] + Log[3 - 6*x + 6*x^2 - 3*x^3] - 3*Log[(-2^(1/3))*(-1 + x) + (1 - x^3)^(1/3)]))/(4*2^(1/3)) - ((a - b - 2*c)*(2*Sqrt[3]*ArcTan[(1 - (2*2^(1/3)*x)/(1 - x^3)^(1/3))/Sqrt[3]] - 3*Log[2^(1/3)*x + (1 - x^3)^(1/3)]))/(12*2^(1/3))}


(* ::Section::Closed:: *)
(* 27 March 2016*)


{1/((1 + x + 2*x^2)^5*(3 - 2*x)^(11/2)), x, 19, -(19255/(395136*(3 - 2*x)^(9/2))) - 462025/(30118144*(3 - 2*x)^(7/2)) - 38491/(8605184*(3 - 2*x)^(5/2)) - 141045/(120472576*(3 - 2*x)^(3/2)) - 38225/(240945152*Sqrt[3 - 2*x]) + x/(28*(3 - 2*x)^(9/2)*(1 + x + 2*x^2)^4) + (23 + 73*x)/(1176*(3 - 2*x)^(9/2)*(1 + x + 2*x^2)^3) + (1387 + 3049*x)/(32928*(3 - 2*x)^(9/2)*(1 + x + 2*x^2)^2) + (5*(3049 + 4377*x))/(153664*(3 - 2*x)^(9/2)*(1 + x + 2*x^2)) + (5*Sqrt[(1/2)*(149046503977 + 40815066112*Sqrt[14])]*ArcTan[(Sqrt[7 + 2*Sqrt[14]] - 2*Sqrt[3 - 2*x])/Sqrt[-7 + 2*Sqrt[14]]])/3373232128 - (5*Sqrt[(1/2)*(149046503977 + 40815066112*Sqrt[14])]*ArcTan[(Sqrt[7 + 2*Sqrt[14]] + 2*Sqrt[3 - 2*x])/Sqrt[-7 + 2*Sqrt[14]]])/3373232128 + (5*Sqrt[(1/2)*(-149046503977 + 40815066112*Sqrt[14])]*Log[3 + Sqrt[14] - Sqrt[7 + 2*Sqrt[14]]*Sqrt[3 - 2*x] - 2*x])/6746464256 - (5*Sqrt[(1/2)*(-149046503977 + 40815066112*Sqrt[14])]*Log[3 + Sqrt[14] + Sqrt[7 + 2*Sqrt[14]]*Sqrt[3 - 2*x] - 2*x])/6746464256}
{1/((1 + x + 2*x^2)^10*(3 - 2*x)^(21/2)), x, 29, 4718120139975/(351733660450816*(3 - 2*x)^(19/2)) - 815900548375/(629418129227776*(3 - 2*x)^(17/2)) - 3029508823715/(1555033025150976*(3 - 2*x)^(15/2)) - 13515743021825/(13476952884641792*(3 - 2*x)^(13/2)) - 5846828446875/(14513641568075776*(3 - 2*x)^(11/2)) - 37283626871975/(261245548225363968*(3 - 2*x)^(9/2)) - 132355162272575/(2844673747342852096*(3 - 2*x)^(7/2)) - 11557581705725/(812763927812243456*(3 - 2*x)^(5/2)) - 46601678385075/(11378694989371408384*(3 - 2*x)^(3/2)) - 24229218097975/(22757389978742816768*Sqrt[3 - 2*x]) + x/(63*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^9) + (53 + 173*x)/(7056*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^8) + (8477 + 21409*x)/(691488*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^7) + (5*(21409 + 47471*x))/(6453888*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^6) + (41*(47471 + 92875*x))/(90354432*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^5) + (41*(3436375 + 5677637*x))/(5059848192*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^4) + (451*(811091 + 998691*x))/(10119696384*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^3) + (451*(28962039 + 14627273*x))/(283351498752*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)^2) + (11275*(14627273 - 35058731*x))/(3966920982528*(3 - 2*x)^(19/2)*(1 + x + 2*x^2)) + (11275*Sqrt[(1/2)*(7 + 2*Sqrt[14])]*(9756589235 + 2148932869*Sqrt[14])*ArcTan[(Sqrt[7 + 2*Sqrt[14]] - 2*Sqrt[3 - 2*x])/Sqrt[-7 + 2*Sqrt[14]]])/318603459702399434752 - (11275*Sqrt[(1/2)*(7 + 2*Sqrt[14])]*(9756589235 + 2148932869*Sqrt[14])*ArcTan[(Sqrt[7 + 2*Sqrt[14]] + 2*Sqrt[3 - 2*x])/Sqrt[-7 + 2*Sqrt[14]]])/318603459702399434752 + (11275*(9756589235 - 2148932869*Sqrt[14])*Sqrt[(1/2)*(-7 + 2*Sqrt[14])]*Log[3 + Sqrt[14] - Sqrt[7 + 2*Sqrt[14]]*Sqrt[3 - 2*x] - 2*x])/637206919404798869504 - (11275*(9756589235 - 2148932869*Sqrt[14])*Sqrt[(1/2)*(-7 + 2*Sqrt[14])]*Log[3 + Sqrt[14] + Sqrt[7 + 2*Sqrt[14]]*Sqrt[3 - 2*x] - 2*x])/637206919404798869504}
{1/((1 + x + 2*x^2)^20*(3 - 2*x)^(41/2)), x, 49, -(13056959628363355534285785425/(106924014357253562723941220352*(3 - 2*x)^(39/2))) - 3948194343291401740321996415/(202881463139404195937734623232*(3 - 2*x)^(37/2)) - 304688229262620222736480811/(537361713180043545997243056128*(3 - 2*x)^(35/2)) + 2124315846756567455653862925/(1688851098565851144562763890688*(3 - 2*x)^(33/2)) + 47657515074514118796095929535/(66632852434325399703658138959872*(3 - 2*x)^(31/2)) + 34911619993974714062172751985/(124667917457770102671360389021696*(3 - 2*x)^(29/2)) + 149066309808794760843017404825/(1624981820656451683095663001731072*(3 - 2*x)^(27/2)) + 15848613964169066543734380171/(601845118761648771516912222863360*(3 - 2*x)^(25/2)) + 11155168222970774232376891145/(1685166332532616560247354224017408*(3 - 2*x)^(23/2)) + 14011818498091020272474956375/(10110997995195699361484125344104448*(3 - 2*x)^(21/2)) + 173441368149804378661935869705/(896508488907352010051592447177261056*(3 - 2*x)^(19/2)) - 22724090823469905152713519545/(1604278348571050965355481221264572416*(3 - 2*x)^(17/2)) - 101190274412779618678573275245/(3963511214116714149701777134888943616*(3 - 2*x)^(15/2)) - 460503190416958283087439337135/(34350430522344855964082068502370844672*(3 - 2*x)^(13/2)) - 2211619588790911794826342607495/(406920484649315986036049119181931544576*(3 - 2*x)^(11/2)) - 143401467550777247627940437025/(73985542663511997461099839851260280832*(3 - 2*x)^(9/2)) - 4611053278117143010907562317585/(7250583181024175751187784305423507521536*(3 - 2*x)^(7/2)) - 405965372440630510720926890227/(2071595194578335928910795515835287863296*(3 - 2*x)^(5/2)) - 4986681479187781853417316522775/(87006998172290109014253411665082090258432*(3 - 2*x)^(3/2)) - 927027754781476746208047620505/(58004665448193406009502274443388060172288*Sqrt[3 - 2*x]) + x/(133*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^19) + (113 + 373*x)/(33516*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^18) + (40657 + 107329*x)/(7976808*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^17) + (5*(751303 + 1831285*x))/(595601664*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^16) + (184959785 + 429411497*x)/(25015269888*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^15) + (41652915209 + 92630823167*x)/(4902992898048*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^14) + (2871555518177 + 6100156355517*x)/(297448235814912*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^13) + (77559130805859 + 156274047129113*x)/(7138757659557888*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^12) + (5*(2656658801194921 + 5020880176134289*x))/(1099368679571914752*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^11) + (45187921585208601 + 78752911037377255*x)/(3420258114223734784*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^10) + (6063974149878048635 + 9477172618423641847*x)/(430952522392190582784*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^9) + (691833601144925854831 + 919498192874055581221*x)/(48266682507925345271808*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^8) + (23*(919498192874055581221 + 908287136092467468517*x))/(1576711628592227945545728*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^7) + (115*(908287136092467468517 + 298281884944522225747*x))/(10187982830903626725064704*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^6) + (23*(2599313568802265110081 - 10426142448623187379187*x))/(20375965661807253450129408*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^5) - (23*(10426142448623187379187 + 27513723463194262383705*x))/(20018492580021161284337664*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^4) - (115*(26513224428169016478843 + 30673415406553789342019*x))/(76434244396444433994743808*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^3) - (115*(88411609113007981044643 - 5712269536245152162963*x))/(125891696652967303050166272*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)^2) + (115*(28561347681225760814815 + 965934812839019490346107*x))/(195831528126838026966925312*(3 - 2*x)^(39/2)*(1 + x + 2*x^2)) + (115*Sqrt[(1/2)*(7 + 2*Sqrt[14])]*(30297118912219360725028693061 + 8061110911143276053983022787*Sqrt[14])*ArcTan[(Sqrt[7 + 2*Sqrt[14]] - 2*Sqrt[3 - 2*x])/Sqrt[-7 + 2*Sqrt[14]]])/812065316274707684133031842207432842412032 - (115*Sqrt[(1/2)*(7 + 2*Sqrt[14])]*(30297118912219360725028693061 + 8061110911143276053983022787*Sqrt[14])*ArcTan[(Sqrt[7 + 2*Sqrt[14]] + 2*Sqrt[3 - 2*x])/Sqrt[-7 + 2*Sqrt[14]]])/812065316274707684133031842207432842412032 + (115*(30297118912219360725028693061 - 8061110911143276053983022787*Sqrt[14])*Sqrt[(1/2)*(-7 + 2*Sqrt[14])]*Log[3 + Sqrt[14] - Sqrt[7 + 2*Sqrt[14]]*Sqrt[3 - 2*x] - 2*x])/1624130632549415368266063684414865684824064 - (115*(30297118912219360725028693061 - 8061110911143276053983022787*Sqrt[14])*Sqrt[(1/2)*(-7 + 2*Sqrt[14])]*Log[3 + Sqrt[14] + Sqrt[7 + 2*Sqrt[14]]*Sqrt[3 - 2*x] - 2*x])/1624130632549415368266063684414865684824064}


{1/((1 + x + 2*x^2)^5*(3 - 2*x + x^2)^(11/2)), x, 14, -((3450497 - 2004270*x)/(123480000*(3 - 2*x + x^2)^(9/2))) - (4878869 - 2578034*x)/(411600000*(3 - 2*x + x^2)^(7/2)) - (30316369 - 15043110*x)/(6860000000*(3 - 2*x + x^2)^(5/2)) - (63043297 - 29625922*x)/(41160000000*(3 - 2*x + x^2)^(3/2)) - (31*(7434109 - 3088870*x))/(411600000000*Sqrt[3 - 2*x + x^2]) - (1 - 10*x)/(280*(3 - 2*x + x^2)^(9/2)*(1 + x + 2*x^2)^4) + (28 + 67*x)/(1050*(3 - 2*x + x^2)^(9/2)*(1 + x + 2*x^2)^3) + (5485 + 8878*x)/(117600*(3 - 2*x + x^2)^(9/2)*(1 + x + 2*x^2)^2) + (3*(8822 + 8233*x))/(343000*(3 - 2*x + x^2)^(9/2)*(1 + x + 2*x^2)) + (Sqrt[(1/70)*(151363871237318045 + 110320475741093888*Sqrt[2])]*ArcTan[(Sqrt[5/(7*(151363871237318045 + 110320475741093888*Sqrt[2]))]*(308108167 + 312239803*Sqrt[2] + (932587773 + 620347970*Sqrt[2])*x))/Sqrt[3 - 2*x + x^2]])/137200000000 - (Sqrt[(1/70)*(-151363871237318045 + 110320475741093888*Sqrt[2])]*ArcTanh[(Sqrt[5/(7*(-151363871237318045 + 110320475741093888*Sqrt[2]))]*(308108167 - 312239803*Sqrt[2] + (932587773 - 620347970*Sqrt[2])*x))/Sqrt[3 - 2*x + x^2]])/137200000000}
{1/((1 + x + 2*x^2)^10*(3 - 2*x + x^2)^(21/2)), x, 24, (37358055634422583 - 14024622879097678*x)/(1840124479200000000*(3 - 2*x + x^2)^(19/2)) + (476849951294984711 - 125181871472148210*x)/(104273720488000000000*(3 - 2*x + x^2)^(17/2)) + (7851758375483333511 + 1942164996204584234*x)/(15641058073200000000000*(3 - 2*x + x^2)^(15/2)) - (11*(7502325106308201089 - 7813986379726516886*x))/(406667509903200000000000*(3 - 2*x + x^2)^(13/2)) - (3*(69053268515296359011 - 44840736195018286006*x))/(1147010925368000000000000*(3 - 2*x + x^2)^(11/2)) - (838519439380295335657 - 466189390555853643870*x)/(9384634843920000000000000*(3 - 2*x + x^2)^(9/2)) - (1117646664729238460189 - 568839749685437871554*x)/(31282116146400000000000000*(3 - 2*x + x^2)^(7/2)) - (6551405511565449301689 - 3127298559983309301910*x)/(521368602440000000000000000*(3 - 2*x + x^2)^(5/2)) - (4179039782398459850819 - 1886993445589652402694*x)/(1042737204880000000000000000*(3 - 2*x + x^2)^(3/2)) - (12105495874518671061833 - 5117656435043679338190*x)/(10427372048800000000000000000*Sqrt[3 - 2*x + x^2]) - (1 - 10*x)/(630*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^9) + (887 + 2218*x)/(88200*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^8) + (14453 + 29371*x)/(1080450*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^7) + (8837931 + 17459234*x)/(605052000*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^6) + (447940041 + 813432205*x)/(26471025000*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^5) + (592729157441 + 911061463974*x)/(29647548000000*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^4) + (277010166219 + 310705340015*x)/(12353145000000*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^3) + (5488221294349 + 1384103301166*x)/(276710448000000*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)^2) - (37857197792117 + 146548895467025*x)/(2421216420000000*(3 - 2*x + x^2)^(19/2)*(1 + x + 2*x^2)) + (1/32282885600000000000000000)*(Sqrt[(1/70)*(81042225921274689605478944797800854846405 + 57305922523001707126026363878666500308992*Sqrt[2])]*ArcTan[(1/Sqrt[3 - 2*x + x^2])*(Sqrt[5/(7*(81042225921274689605478944797800854846405 + 57305922523001707126026363878666500308992*Sqrt[2]))]*(272944589523248381749 + 191941026386645109841*Sqrt[2] + (656826642296538601431 + 464885615909893491590*Sqrt[2])*x))]) - (1/32282885600000000000000000)*(Sqrt[(1/70)*(-81042225921274689605478944797800854846405 + 57305922523001707126026363878666500308992*Sqrt[2])]*ArcTanh[(1/Sqrt[3 - 2*x + x^2])*(Sqrt[5/(7*(-81042225921274689605478944797800854846405 + 57305922523001707126026363878666500308992*Sqrt[2]))]*(272944589523248381749 - 191941026386645109841*Sqrt[2] + (656826642296538601431 - 464885615909893491590*Sqrt[2])*x))])}
(* {1/((1 + x + 2*x^2)^20*(3 - 2*x + x^2)^(41/2)), x, 44, -((3383098994350701191445410431293305057 - 4267253240538659853185782736614548266*x)/(525136027977674906956800000000000000000*(3 - 2*x + x^2)^(39/2))) - (78177705015622070276322636989526467357 - 46302218258158218301107776830095849518*x)/(10226333176407353451264000000000000000000*(3 - 2*x + x^2)^(37/2)) - (590941515369388885204630563227557418493 - 284553012686483535620642865600923199674*x)/(170438886273455890854400000000000000000000*(3 - 2*x + x^2)^(35/2)) - (762583115349707009263396051658444299451 - 316786081987045018642707627274029983850*x)/(661703911414593458611200000000000000000000*(3 - 2*x + x^2)^(33/2)) - (20504482297963009703756354886476682604921 - 7087722971997170533955928118157817528778*x)/(68376070846174657389824000000000000000000000*(3 - 2*x + x^2)^(31/2)) - (1094782756101056712471590885456644828438471 - 231319367589693551565762758087902994595834*x)/(19829060545390650643048960000000000000000000000*(3 - 2*x + x^2)^(29/2)) - (11012693190699376908809163895637681160105723 + 17696165071101966113331245255080607119456186*x)/(5353846347255475673623219200000000000000000000000*(3 - 2*x + x^2)^(27/2)) + (23*(18006082293219149330614702781906676996906581 - 12878862225352936849259678853843700644232934*x))/(102958583601066839877369600000000000000000000000000*(3 - 2*x + x^2)^(25/2)) + (3754355493750207391617343068085143489914966741 - 1976623777595197423359895741289079398167213586*x)/(1578698281883024878119667200000000000000000000000000*(3 - 2*x + x^2)^(23/2)) + (34322768124014799813009030113095008046843253 - 15319362686882129647628001638529620053980446*x)/(37439484945842487228134400000000000000000000000000*(3 - 2*x + x^2)^(21/2)) + (1953413335087203199033100669694117118003927337 - 733793240328640817816796967921215709697806706*x)/(7113502139710072573345536000000000000000000000000000*(3 - 2*x + x^2)^(19/2)) + (8322318541720916240549421691461341741448155507 - 2188425336528033679699131827282128928574446618*x)/(134366151527856926385415680000000000000000000000000000*(3 - 2*x + x^2)^(17/2)) + (137736099847510239083414355324468252291068692723 + 33478342054315312692979309199522921351750372786*x)/(20154922729178538957812352000000000000000000000000000000*(3 - 2*x + x^2)^(15/2)) - (1430395239362680496541085612662519163791606856135 - 1495983440171367688360072315937267940781419612058*x)/(524027990958642012903121152000000000000000000000000000000*(3 - 2*x + x^2)^(13/2)) - (46873324150704277658299560286668706773614009227097 - 30488099877102642762965997747126514882873436125826*x)/(19214359668483540473114442240000000000000000000000000000000*(3 - 2*x + x^2)^(11/2)) - (2090128362125698805507947714009988943496892649558547 - 1163930059835896170450961511486397522547379198063338*x)/(1729292370163518642580299801600000000000000000000000000000000*(3 - 2*x + x^2)^(9/2)) - (8369636990081146161067558056610779041437928173813933 - 4269376136031342769573244116290179332114846542231394*x)/(17292923701635186425802998016000000000000000000000000000000000*(3 - 2*x + x^2)^(7/2)) - (49166828083706788194824969884579797183621714007506697 - 23559210708081011868758976108072328010974084474928758*x)/(288215395027253107096716633600000000000000000000000000000000000*(3 - 2*x + x^2)^(5/2)) - (94521492350271713145340025542493858321141702707908121 - 43021608081072494822903916879274373698601078834559154*x)/(1729292370163518642580299801600000000000000000000000000000000000*(3 - 2*x + x^2)^(3/2)) - (279132222218499281305380296125539838445333294423861707 - 121216775195529638294422516813426829250767045105497738*x)/(17292923701635186425802998016000000000000000000000000000000000000*Sqrt[3 - 2*x + x^2]) - (1 - 10*x)/(1330*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^19) + (1877 + 4778*x)/(418950*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^18) + (39403 + 85822*x)/(7122150*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^17) + (13*(233559 + 522986*x))/(531787200*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^16) + (87552089 + 193315879*x)/(13959414000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^15) + (383091931241 + 813307430102*x)/(54720902880000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^14) + (15997439501471 + 32531972209601*x)/(2074834234200000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^13) + (11661968128341449 + 22618400149542870*x)/(1394288605382400000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^12) + (3*(44358079769457553 + 81352009087314543*x))/(14911142029784000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^11) + (55501961232421996697 + 95060342178362451574*x)/(5964456811913600000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^10) + (4402445415670842624937 + 6915121726888913987767*x)/(469700973938196000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^9) + (9405293191839054568597199 + 13154801664162951037742138*x)/(1052130181621559040000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^8) + (33329414380999440825700335 + 39194075260407572910301649*x)/(4296198241621366080000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^7) + (3079446144576372279132551987 + 2588106060473365045793782354*x)/(555201003532607308800000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^6) + (51676596892030833963565793623 - 3738166859166819756452589047*x)/(24290043904551569760000000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^5) - (18477591983841452420673740004241 + 27597746968514352562858392071302*x)/(9068283057699252710400000000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^4) - (133360959223342832431783756808269 - 49432151929857088186548766720461*x)/(34006061466372197664000000000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^3) + (1057289143422928552044099202272635 + 2439572907056622740540415493441154*x)/(115414511643445034496000000000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)^2) + (27710574638863668700887240018723697 - 1800525975551829959478731340624273*x)/(336625658960048017280000000000000000*(3 - 2*x + x^2)^(39/2)*(1 + x + 2*x^2)) + (53*Sqrt[(1/70)*(879210910919588630492825297744872020413651017635360866499074296032260778656372643901 + 621696002391807670114685903911372073177064710967794175872353924738917423916160909312*Sqrt[2])]*ArcTan[(1/Sqrt[3 - 2*x + x^2])*(Sqrt[5/(7*(879210910919588630492825297744872020413651017635360866499074296032260778656372643901 + 621696002391807670114685903911372073177064710967794175872353924738917423916160909312*Sqrt[2]))]*(896457640030471180988134177305100813179145 + 634009778425632881804463219060525222303381*Sqrt[2] + (2164477196881736944597060615426151257785907 + 1530467418456104062792597396365626035482526*Sqrt[2])*x))])/416873881065074944000000000000000000000000000000000000 - (53*Sqrt[(1/70)*(-879210910919588630492825297744872020413651017635360866499074296032260778656372643901 + 621696002391807670114685903911372073177064710967794175872353924738917423916160909312*Sqrt[2])]*ArcTanh[(1/Sqrt[3 - 2*x + x^2])*(Sqrt[5/(7*(-879210910919588630492825297744872020413651017635360866499074296032260778656372643901 + 621696002391807670114685903911372073177064710967794175872353924738917423916160909312*Sqrt[2]))]*(896457640030471180988134177305100813179145 - 634009778425632881804463219060525222303381*Sqrt[2] + (2164477196881736944597060615426151257785907 - 1530467418456104062792597396365626035482526*Sqrt[2])*x))])/416873881065074944000000000000000000000000000000000000} *)


(* ::Section::Closed:: *)
(* 19 June 2016*)


{(x - a - Sqrt[a^2 + 1])/((x - a + Sqrt[a^2 + 1])*Sqrt[(x - a)*(x^2 + 1)]), x, -6, (-Sqrt[2])*Sqrt[a + Sqrt[1 + a^2]]*ArcTan[(Sqrt[2]*Sqrt[-a + Sqrt[1 + a^2]]*(-a + x))/Sqrt[(-a + x)*(1 + x^2)]]}


(* ::Section::Closed:: *)
(* 17 August 2016*)


{(a + b*x)/((3 + x^2)*(1 - x^2)^(1/3)), x, 9, (a*ArcTan[1/Sqrt[3] - (2^(2/3)*(1 - x)^(2/3))/(Sqrt[3]*(1 + x)^(1/3))])/(2*2^(2/3)*Sqrt[3]) - (a*ArcTan[1/Sqrt[3] - (2^(2/3)*(1 + x)^(2/3))/(Sqrt[3]*(1 - x)^(1/3))])/(2*2^(2/3)*Sqrt[3]) + (Sqrt[3]*b*ArcTan[(1 + 2^(1/3)*(1 - x^2)^(1/3))/Sqrt[3]])/(2*2^(2/3)) - (b*Log[3 + x^2])/(4*2^(2/3)) - (a*Log[(1 - x)^(2/3) + 2^(1/3)*(1 + x)^(1/3)])/(4*2^(2/3)) + (a*Log[2^(1/3)*(1 - x)^(1/3) + (1 + x)^(2/3)])/(4*2^(2/3)) + (3*b*Log[2^(2/3) - (1 - x^2)^(1/3)])/(4*2^(2/3))}
{(a + b*x)/((3 - x^2)*(1 + x^2)^(1/3)), x, 9, -((a*ArcTan[1/Sqrt[3] + (2^(2/3)*(Sqrt[3] - x))/(3*(1 + x^2)^(1/3))])/(6*2^(2/3))) + (a*ArcTan[1/Sqrt[3] + (2^(2/3)*(Sqrt[3] + x))/(3*(1 + x^2)^(1/3))])/(6*2^(2/3)) - (Sqrt[3]*b*ArcTan[(1 + 2^(1/3)*(1 + x^2)^(1/3))/Sqrt[3]])/(2*2^(2/3)) + (a*Log[Sqrt[3] - x])/(4*2^(2/3)*Sqrt[3]) - (a*Log[Sqrt[3] + x])/(4*2^(2/3)*Sqrt[3]) + (b*Log[3 - x^2])/(4*2^(2/3)) - (3*b*Log[2^(2/3) - (1 + x^2)^(1/3)])/(4*2^(2/3)) + (a*Log[Sqrt[3] - x - 2^(1/3)*Sqrt[3]*(1 + x^2)^(1/3)])/(4*2^(2/3)*Sqrt[3]) - (a*Log[Sqrt[3] + x - 2^(1/3)*Sqrt[3]*(1 + x^2)^(1/3)])/(4*2^(2/3)*Sqrt[3])}
{1/(x*(3*x^2 - 6*x + 4)^(1/3)), x, -1, ArcTan[(-2 + x - 2*2^(1/3)*(4 - 6*x + 3*x^2)^(1/3))/(Sqrt[3]*(-2 + x))]/(2^(2/3)*Sqrt[3]) + Log[(-4 + 2*x + 2*2^(1/3)*(4 - 6*x + 3*x^2)^(1/3))/x]/(2*2^(2/3))}
{x*(1 - x^3)^(1/3), x, 8, (1/3)*x^2*(1 - x^3)^(1/3) - ArcTan[(1 - (2*x)/(1 - x^3)^(1/3))/Sqrt[3]]/(3*Sqrt[3]) + (1/18)*Log[1 + x^2/(1 - x^3)^(2/3) - x/(1 - x^3)^(1/3)] - (1/9)*Log[1 + x/(1 - x^3)^(1/3)]}
{(1 - x^3)^(1/3)/x, x, 6, (1 - x^3)^(1/3) - ArcTan[(1 + 2*(1 - x^3)^(1/3))/Sqrt[3]]/Sqrt[3] - Log[x]/2 + (1/2)*Log[1 - (1 - x^3)^(1/3)]}
{(1 - x^3)^(1/3)/(1 + x), x, -1, 0}
{(1 - x^3)^(1/3)/(1 - x + x^2), x, -2, (Sqrt[3]*ArcTan[(1 + (2*2^(1/3)*(-1 + x))/(1 - x^3)^(1/3))/Sqrt[3]])/2^(2/3) + ArcTan[(1 - (2*x)/(1 - x^3)^(1/3))/Sqrt[3]]/Sqrt[3] - ArcTan[(1 - (2*2^(1/3)*x)/(1 - x^3)^(1/3))/Sqrt[3]]/(2^(2/3)*Sqrt[3]) - ArcTan[(1 + 2^(2/3)*(1 - x^3)^(1/3))/Sqrt[3]]/(2^(2/3)*Sqrt[3]) - Log[-3*(-1 + x)*(1 - x + x^2)]/(2*2^(2/3)) + Log[2^(1/3) - (1 - x^3)^(1/3)]/(2*2^(2/3)) + (3*Log[(-2^(1/3))*(-1 + x) + (1 - x^3)^(1/3)])/(2*2^(2/3)) + (1/2)*Log[x + (1 - x^3)^(1/3)] - Log[2^(1/3)*x + (1 - x^3)^(1/3)]/(2*2^(2/3))}


(* ::Section::Closed:: *)
(* 22 September 2016*)


(* {1/(x^3 - 3*x^2 + 7*x - 4)^(1/3), x, -4, 0}
{1/(x*(3*x^2 - 6*x + 5)^(1/3)), x, -2, 0}
{(1 - x^3)^(1/3)/(2 + x), x, -1, 0}
{(2 + x)/((1 + x + x^2)*(2 + x^3)^(1/3)), x, -2, 0} *)


(* ::Section::Closed:: *)
(* 12 January 2017*)


(* {(1 + x)/((1 + x + x^2)*(a + b*x^3)^(1/3)), x, 0, 0} *)


(* ::Section::Closed:: *)
(* 14 January 2017*)


{(3 - 3*x + 30*x^2 + 160*x^3)/(9 + 24*x - 12*x^2 + 80*x^3 + 320*x^4), x, 1, (1/8)*Log[9 + 24*x - 12*x^2 + 80*x^3 + 320*x^4]}
{(3 + 12*x + 20*x^2)/(9 + 24*x - 12*x^2 + 80*x^3 + 320*x^4), x, 1, -(ArcTan[(7 - 40*x)/(5*Sqrt[11])]/(2*Sqrt[11])) + ArcTan[(57 + 30*x - 40*x^2 + 800*x^3)/(6*Sqrt[11])]/(2*Sqrt[11])}
{-((84 + 576*x + 400*x^2 - 2560*x^3)/(9 + 24*x - 12*x^2 + 80*x^3 + 320*x^4)), x, 2, 2*Sqrt[11]*ArcTan[(7 - 40*x)/(5*Sqrt[11])] - 2*Sqrt[11]*ArcTan[(57 + 30*x - 40*x^2 + 800*x^3)/(6*Sqrt[11])] + 2*Log[9 + 24*x - 12*x^2 + 80*x^3 + 320*x^4]}


(* ::Section::Closed:: *)
(* 31 January 2017*)


{Sqrt[1 - x^4]/(1 + x^4), x, 1, (1/2)*ArcTan[(x*(1 + x^2))/Sqrt[1 - x^4]] + (1/2)*ArcTanh[(x*(1 - x^2))/Sqrt[1 - x^4]]}
{Sqrt[1 + x^4]/(1 - x^4), x, 4, ArcTan[(Sqrt[2]*x)/Sqrt[1 + x^4]]/(2*Sqrt[2]) + ArcTanh[(Sqrt[2]*x)/Sqrt[1 + x^4]]/(2*Sqrt[2])}


(* ::Section::Closed:: *)
(* 7 February 2017*)


{Sqrt[1 + p*x^2 + x^4]/(1 - x^4), x, 4, (1/4)*Sqrt[2 - p]*ArcTan[(Sqrt[2 - p]*x)/Sqrt[1 + p*x^2 + x^4]] + (1/4)*Sqrt[2 + p]*ArcTanh[(Sqrt[2 + p]*x)/Sqrt[1 + p*x^2 + x^4]]}
{Sqrt[1 + p*x^2 - x^4]/(1 + x^4), x, 1, -((Sqrt[p + Sqrt[4 + p^2]]*ArcTan[(Sqrt[p + Sqrt[4 + p^2]]*x*(p - Sqrt[4 + p^2] - 2*x^2))/(2*Sqrt[2]*Sqrt[1 + p*x^2 - x^4])])/(2*Sqrt[2])) + (Sqrt[-p + Sqrt[4 + p^2]]*ArcTanh[(Sqrt[-p + Sqrt[4 + p^2]]*x*(p + Sqrt[4 + p^2] - 2*x^2))/(2*Sqrt[2]*Sqrt[1 + p*x^2 - x^4])])/(2*Sqrt[2])}


(* ::Section::Closed:: *)
(* 28 August 2017*)


{(a + b*x)/((2 - x^2)*(-1 + x^2)^(1/4)), x, 7, (a*ArcTan[x/(Sqrt[2]*(-1 + x^2)^(1/4))])/(2*Sqrt[2]) - b*ArcTan[(-1 + x^2)^(1/4)] + (a*ArcTanh[x/(Sqrt[2]*(-1 + x^2)^(1/4))])/(2*Sqrt[2]) + b*ArcTanh[(-1 + x^2)^(1/4)]}
{(a + b*x)/((2 + x^2)*(-1 - x^2)^(1/4)), x, 7, (a*ArcTan[x/(Sqrt[2]*(-1 - x^2)^(1/4))])/(2*Sqrt[2]) + b*ArcTan[(-1 - x^2)^(1/4)] + (a*ArcTanh[x/(Sqrt[2]*(-1 - x^2)^(1/4))])/(2*Sqrt[2]) - b*ArcTanh[(-1 - x^2)^(1/4)]}

{(a + b*x)/((2 - x^2)*(1 - x^2)^(1/4)), x, 3, (b*ArcTan[(1 - Sqrt[1 - x^2])/(Sqrt[2]*(1 - x^2)^(1/4))])/Sqrt[2] + (1/2)*a*ArcTan[(1 - Sqrt[1 - x^2])/(x*(1 - x^2)^(1/4))] + (b*ArcTanh[(1 + Sqrt[1 - x^2])/(Sqrt[2]*(1 - x^2)^(1/4))])/Sqrt[2] + (1/2)*a*ArcTanh[(1 + Sqrt[1 - x^2])/(x*(1 - x^2)^(1/4))]}
{(a + b*x)/((2 + x^2)*(1 + x^2)^(1/4)), x, 3, -((b*ArcTan[(1 - Sqrt[1 + x^2])/(Sqrt[2]*(1 + x^2)^(1/4))])/Sqrt[2]) - (1/2)*a*ArcTan[(1 + Sqrt[1 + x^2])/(x*(1 + x^2)^(1/4))] - (1/2)*a*ArcTanh[(1 - Sqrt[1 + x^2])/(x*(1 + x^2)^(1/4))] - (b*ArcTanh[(1 + Sqrt[1 + x^2])/(Sqrt[2]*(1 + x^2)^(1/4))])/Sqrt[2]}


(* {(3 + x^2)/((1 + x^2)*(1 + 6*x^2 + x^4)^(1/4)), x, 0, 0}
{(3 - x^2)/((1 - x^2)*(1 - 6*x^2 + x^4)^(1/4)), x, 0, 0} *)
